EvaluateScript("entities.js");
EvaluateScript("keys.js");
EvaluateScript("levels.js");
EvaluateScript("cutscenes.js");
EvaluateScript("audio.js")
font = GetSystemFont();

scale_x = 2
scale_y = 2

function game()
{
	if (!IsKeyPressed(CKEY_ESCAPE))
		Intro();
	GameStart();
}

function Intro()
{
	image = LoadImage("required_tojam9certified.png")
	f_rate = 30
	maxy = 50
	maxy2 = 100
	j = 0;
	l_time = GetTime()
	for (i=0;i<maxy;i++)
	{
		while(GetTime()-l_time < f_rate)
		{
			image.transformBlit(0,0, GetScreenWidth(), 0, GetScreenWidth(), GetScreenHeight(), 0, GetScreenHeight())
			Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255-255*i/maxy))
			FlipScreen()
		}
		l_time = GetTime()
		while (AreKeysLeft())
		{
		   key = GetKey()
		   if (key == CKEY_ENTER || key == CKEY_ESCAPE || key == CKEY_SPACE)
		   {
					j=maxy2;
					break
		   }
		}
		if (j==maxy2)
			break;
	}
	for (;j<maxy2;j++)
	{
		while(GetTime()-l_time < f_rate)
		{
		image.transformBlit(0,0, GetScreenWidth(), 0, GetScreenWidth(), GetScreenHeight(), 0, GetScreenHeight())
		Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255-255*i/maxy))
		FlipScreen()
		}
		l_time = GetTime()
		while (AreKeysLeft())
		{
		   key = GetKey()
		   if (key == CKEY_ENTER || key == CKEY_ESCAPE || key == CKEY_SPACE)
		   {
					j=maxy2;
					break
		   }
		}
	}
	for (;i>0;i--)
	{
		while(GetTime()-l_time < f_rate)
		{
		image.transformBlit(0,0, GetScreenWidth(), 0, GetScreenWidth(), GetScreenHeight(), 0, GetScreenHeight())
		Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255-	255*i/maxy))
		FlipScreen()
		}
		l_time = GetTime()
	}
}

function Menu()
{
  SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "")
	level=Math.floor(Math.random()*(levels.length))
	LoadLevel(level, undefined, true)
	
	f_rate = 1000/60
	l_time = GetTime()
	mouse = LoadImage("menu_cursor.png");
	mframes = 0
	selection = 0
	x_off = [scale_x*24, scale_x*24, scale_x*22]

	for (i=0;i<levels[level].menu.length;i++)
	{ 
	  if (i!= 1)
	  {
			d = levels[level].menu[i]
			SetTile(d[0],d[1], 3, 36+i*2)
			SetTile(d[0]+1,d[1], 3, 37+i*2)
		}
	}
	
	function DrawMenu()
	{
		x_off_now = x_off[selection]+4*scale_x*Math.sin(mframes/8)
		mouse.zoomBlit(levels[level].menu[selection][0]*GetTileWidth()*scale_x+x_off_now,levels[level].menu[selection][1]*GetTileHeight()*scale_y, scale_x)
	}
	
	maxy_fade = 240
	
	while (true)
	{
		while (GetTime()-l_time < f_rate)
		{
			RenderMap();
			DrawMenu()
			if (mframes < maxy_fade)
				Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255-255*mframes/maxy_fade)); 
			FlipScreen()
			
		}
		UpdateMapEngine();
		mframes+=1
		
		
		while(AreKeysLeft())
		{
			key = GetKey()
			if (key == CKEY_DOWN)
			{
				selection+=2
				PlaySound(4);
			}
			if (key == CKEY_UP)
			{
				selection-=2
				PlaySound(4);
			}
			if (selection < 0)
				selection = 0;
			if (selection > 2)
				selection = 2;
				
			if (key == CKEY_ENTER)
			{
				if (selection == 0)
				{
					PlaySound(6);
					GameInit()
					ExitMapEngine()
					return
				}
				else if (selection == 2)
				{
					PlaySound(6);
					ExitMapEngine()
					return
				}
			}
		}
		l_time = GetTime()
	
	}
		
	GameInit()
	ExitMapEngine()
}

function GameStart()
{
	SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "Menu();")
	MapEngine("level0.rmp", 60)
}



function GameInit()
{
  SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "")
	CreatePerson("main1", "main1.rss", false)
	CreatePerson("main2", "main2.rss", false)
	LoadLevel(0, true)
	GameLoop();
}


g_frames = 0
g_frame_updater = 5;
g_level = 0
function GameLoop()
{

  t_time = GetTime()
  f_rate = 1000/60;
  g_frames = 0
  
  UpdateEntities();
	//Fade in here.
	CutScene1();
  while (true)
  {
		while (GetTime()-t_time < f_rate)
		{
		}
		t_time = GetTime()

    RenderMap();

		UpdateMapEngine();
    FlipScreen();
    UpdateInput();
    UpdateEntities();
		UpdateComboSwitches();
		UpdateReleaseSwitches();
    g_frames+=1;
  }  
}

g_tab_pressed = false
g_up_pressed = false
g_user = 0

function UpdateInput()
{
		if (entities[0].direction == "die" && g_user == 0)
				return;
				
				
		if (!IsKeyPressed(CKEY_TAB))
			g_tab_pressed = false
		else if (g_tab_pressed == false)
		{
			g_tab_pressed = true;
			g_user = (g_user+1)%2
			if (entities[g_user].level != g_level)
			{
				ChangeLevelDirect(entities[g_user].level);
			}
		}

		if (!IsKeyPressed(CKEY_UP))
			g_up_pressed = false
		else if (g_up_pressed == false)
		{
			g_up_pressed = true;
			TryChangeLevel();
		}


    if (IsKeyPressed(CKEY_RIGHT))
    {
        if (entities[g_user].vx < 1.5)
            entities[g_user].vx+=0.75
         entities[g_user].dir = 1;
    }
    
    if (IsKeyPressed(CKEY_LEFT))
    {
        if (entities[g_user].vx > -1.5)
            entities[g_user].vx -= 0.75;
        entities[g_user].dir = -1;
    }

    if (IsKeyPressed(CKEY_SPACE))
    {
			if (IsEntityObstructed(g_user, entities[g_user].x, entities[g_user].y+1))
			{
			    entities[g_user].vy = -5;
			    PlaySound(3);
			}
    }
    else
    {
			if (entities[g_user].vy < 0)
			{
				entities[g_user].vy+=g_const*2;
			}
    }
    
    if (IsKeyPressed(CKEY_ESCAPE))
    {
			RestartGame()
    }

}

function DebugText(text)
{
	font.drawText(0,0,text);
	FlipScreen();
	while (GetKey() !=KEY_ENTER);
}